﻿if (typeof (MCS) == "undefined")
{ MCS = {}; }
// Create Namespace container for functions in this library;

if (typeof (MCS.ResourcePackage) == "undefined") {
    MCS.ResourcePackage = {};
}


MCS.ResourcePackage.OnLoad = function () {
    if (Xrm.Page.ui.getFormType() == 1) {
        Xrm.Page.ui.tabs.get('tab_sites').sections.get('tab_sites_section_pat').setVisible(false);
        Xrm.Page.ui.tabs.get('tab_sites').sections.get('tab_sites_section_pro').setVisible(false);

        Xrm.Page.ui.tabs.get('tab_approval').sections.get('tab_approval_section_facilityapproval').setVisible(false);
    }

    if (Xrm.Page.ui.getFormType() != 1) {
        Xrm.Page.getControl("cvt_specialty").setDisabled(true);
        Xrm.Page.getControl("cvt_specialtysubtype").setDisabled(true);
        Xrm.Page.getControl("cvt_providerlocationtype").setDisabled(true);
        Xrm.Page.getControl("cvt_patientlocationtype").setDisabled(true);
        Xrm.Page.getControl("cvt_availabletelehealthmodality").setDisabled(true);
        Xrm.Page.getControl("cvt_groupappointment").setDisabled(true);

        Xrm.Page.getControl("cvt_hub").setDisabled(true);
    }
    MCS.ResourcePackage.SOS();
    MCS.ResourcePackage.HM();
};
MCS.ResourcePackage.SOS = function () {
    //Make the SOS field visible and get the url
    if (Xrm.Page.getAttribute("cvt_specialty").getValue() != null) {
        CrmRestKit.Retrieve('mcs_servicetype', Xrm.Page.getAttribute("cvt_specialty").getValue()[0].id, ["cvt_specialtyoperationssupplement"], false).fail(function (err) {
            //alert("fail");
        }).done(function (data) {
            //alert("success");
            var url = data.d["cvt_specialtyoperationssupplement"];

            if (url) {
                Xrm.Page.getAttribute("cvt_specialtyoperationsmanual").setValue(url);
            }
        });
    }
};

MCS.ResourcePackage.setDefaultDurations = function(){
   // var ctlApptLength = Xrm.Page.getControl('cvt_appointmentlength');
	var atrApptLength = Xrm.Page.getAttribute('cvt_appointmentlength');

	//var ctlStartEvery = Xrm.Page.getControl('cvt_startappointmentsevery');
	var atrStartEvery = Xrm.Page.getAttribute('cvt_startappointmentsevery');

	if(Xrm.Page.ui.getFormType() == 1){ //its a new form
	    atrApptLength.setValue(60);
		atrStartEvery.setValue(15);
	}
	else{
	   var valApptLength = atrApptLength.getValue();
	   if((!valApptLength)||(valApptLength==0)){atrApptLength.setValue(60)};

	   var valStartEvery = atrStartEvery.getValue();
	   if((!valStartEvery)||(valStartEvery==0)){atrStartEvery.setValue(15)};
	}
}

MCS.ResourcePackage.HM = function () {
    if (Xrm.Page.getAttribute("cvt_patientlocationtype").getValue() == 917290001) {
        Xrm.Page.ui.tabs.get('tab_sites').sections.get('tab_sites_section_pat').setVisible(false);
        Xrm.Page.ui.tabs.get('tab_approval').setVisible(false);
    }
};

//If specialty value is removed, remove value of specailty sub type and make it read only
//if specialty value exists, make sub type editable
MCS.ResourcePackage.Specialty = function () {
    var specialty = Xrm.Page.getControl("cvt_specialty");
    var specialtysubtype = Xrm.Page.getControl("cvt_specialtysubtype");

    if (Xrm.Page.getAttribute("cvt_specialty").getValue() != null) {
        specialtysubtype.setDisabled(false);
        MCS.ResourcePackage.SOS();
    }
    else {
        Xrm.Page.getAttribute("cvt_specialtysubtype").setValue(null);
        specialtysubtype.setDisabled(true);
    }

};

//[Specialty] [Specialty Sub-Type]: Pat [CB or TW] Pro [CB or HM] [Ind or Grp]
MCS.ResourcePackage.CreateName = function (eventObj) {
    var derivedResultField = "";

    var specialty = Xrm.Page.getAttribute("cvt_specialty").getValue();
    var specialtySubtype = Xrm.Page.getAttribute("cvt_specialtysubtype").getValue();
    var providerLocation = Xrm.Page.getAttribute("cvt_providerlocationtype").getValue();
    var patientLocation = Xrm.Page.getAttribute("cvt_patientlocationtype").getValue();
    var telehealthModality = Xrm.Page.getAttribute("cvt_availabletelehealthmodality").getValue();
    var isGroup = Xrm.Page.getAttribute("cvt_groupappointment").getValue();

    var specialtyName = "";
    var providerLocationText = "Pro";
    var patientLocationText = "Pat";
    var telehealthModalityText = "";
    var isGroupText = "";


    if (specialty != null) {
        specialtyName = specialty[0].name;
        //query for potential abbreviation
        CrmRestKit.Retrieve('mcs_servicetype', Xrm.Page.getAttribute("cvt_specialty").getValue()[0].id, ["cvt_abbreviation"], false).fail(function (err) {
        }).done(function (data) {
            var specialtyAbbrev = data.d["cvt_abbreviation"];

            if (specialtyAbbrev) {
                specialtyName = specialtyAbbrev;
            }
        });

        if (specialtySubtype != null) {
            //query for potential abbreviation
            CrmRestKit.Retrieve('mcs_servicesubtype', Xrm.Page.getAttribute("cvt_specialtysubtype").getValue()[0].id, ["cvt_abbreviation"], false).fail(function (err) {
            }).done(function (data) {
                var specialtySubtypeAbbrev = data.d["cvt_abbreviation"];

                if (specialtySubtypeAbbrev)
                    specialtyName += ":" + specialtySubtypeAbbrev;
                else
                    specialtyName += ":" + specialtySubtype[0].name;
            });
        }
    }

    if (providerLocation != null) {
        switch (providerLocation) {
            case 917290000:
                providerLocationText += " CB";
                break;
            case 917290001:
                providerLocationText += " TW";
                break;
        }
    }

    if (patientLocation != null) {
        switch (patientLocation) {
            case 917290000:
                patientLocationText += " CB";
                break;
            case 917290001:
                patientLocationText += " HM";
                break;
        }
    }

    if (telehealthModality != null) {
        switch (telehealthModality) {
            case 917290000:
                telehealthModalityText = "CVT";
                break;
            case 917290001:
                telehealthModalityText = "SFT";
                break;
        }
    }
    if (isGroup)
        isGroupText = "Grp";
    else
        isGroupText = "Ind";

    derivedResultField = specialtyName + " " + telehealthModalityText + " - " + patientLocationText + ", " + providerLocationText + ", " + isGroupText;

    if (telehealthModalityText == "SFT" && isGroupText == "Grp")
    {
        alert("Preventing Save. Cannot have a Group SFT Scheduling Package. Please change Group or Modality before saving again.")
        eventObj.getEventArgs().preventDefault();
        return;
    }

    if (Xrm.Page.getAttribute("cvt_name").getValue() != derivedResultField) {
        Xrm.Page.getAttribute("cvt_name").setSubmitMode("always");
        Xrm.Page.getAttribute("cvt_name").setValue(derivedResultField);
    }
};